//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Text;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Reflection;

class Sender
{

	public static void Main(string[] args)
	{	
		string address = "localhost";
		if(args.Length == 1)
			address = args[0];

		SendMessage(address);
	}

	public static void SendMessage(string server)
	{
		TcpClient client = new TcpClient();
		client.Connect(server, 5000);
		NetworkStream stream = client.GetStream();

		bool continueSending = true;
		while(continueSending)
		{		
			Console.WriteLine("Wprowad wiadomo do wysania. Wpisz 'quit', aby przerwa.");
			string message = Console.ReadLine();
			// byte[] buffer = Encoding.ASCII.GetBytes(message);
			byte[] buffer = Encoding.Unicode.GetBytes(message);
			stream.Write(buffer, 0, buffer.Length);
			if(message == "quit")
			{
				continueSending = false;
			}	
		}
				
		client.Close();

		// Od: Buksbaum, David [SMTP:david.buksbaum@CSFB.COM]  
		PropertyInfo pi = typeof(TcpClient).GetProperty("Client", 
			BindingFlags.Instance|BindingFlags.NonPublic);
		// mSock to obiekt TcpClient.
		Socket so = (Socket)pi.GetValue(client, null); 
		if((so != null) && (so.Connected)) 
			so.Shutdown(SocketShutdown.Both);

	}
}
